//----------------------------------------------------------------
// KFLOP Initialize program
// K2CNC - Copyright 2013
// Version: 2.0.4
//
// - K2mc_driver.c  -> Thread 6 
// - homing.c  		-> Thread 5
// - toolchange.c   -> Thread 4
// - bitJog_sLimit.c   -> Thread 1
//----------------------------------------------------------------
// Last Modified: 10-02-2013
//
//----------------------------------------------------------------
// Note: Change All Init Settings in \KFLOP\K2_Settings.h
//----------------------------------------------------------------

//#define DEBUG

//----------------------------------------------------------------
#include "KMotionDef.h"
#include "defines.h"
#include "events.h"
#include "util.h"
#include "initServo_StepDir.h"
#include "initStepDir.h"

#define FIRMWARE_VERSION 204

//---------------------------------------------------------
//---------------------------------------------------------

void InitServo(void);
void InitStepper(void);
void InitACStepDir(void);

int SPI_Init();
int SPI_OUT(int data);
void FlashLEDS(void);
static float clock_time(void);
static int timer_expired(struct timer *t);
static void timer_set(struct timer *t, float interval);
void ToggleBit(int bit);

void CallBack(void);

void ReadPersist();
void WritePersist();

double GetPos(int axis);
void Disable(int axis);

void PrintFirmwareVersion();


//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------
main()
{
	int i;

	// pdControlType and pdFirmwareVersion are readonly...
	// make sure they get initalised 
#ifdef DC_SERVO
	persist.UserData[pdControlType] = TYPE_DC_SERVO;
#endif

#ifdef DC_SERVO_REV4
	persist.UserData[pdControlType] = TYPE_DC_SERVO_REV4;
#endif

#ifdef DC_STEP_DIR
	persist.UserData[pdControlType] = TYPE_DC_STEP_DIR;
#endif

#ifdef AC_SERVO_ANALOG
	persist.UserData[pdControlType] = TYPE_AC_SERVO_ANALOG;
#endif

#ifdef AC_SERVO_STEP_DIR
	persist.UserData[pdControlType] = TYPE_AC_SERVO_STEP_DIR;	
#endif

	persist.UserData[pdFirmwareVersion] = FIRMWARE_VERSION;

	// Reset Start-up Current too to Zero
	persist.UserData[pdCurrentTool] = 0;
	
#ifdef DEBUG
	//ClearBit(vbInitialized);
//	SetBitDirection(pESTOP_SW, 1);
//	SetBit(pESTOP_SW);

//	SetBitDirection(pEN_SW, 1);
	
	SetBit(pEN_DRV);
	SetBit(pOutput_Enable);	
	
//	ClearBit(pTangentMode);

//	ClearBit(vbSoftlimitStarted);
//	ClearBit(vbToolChangeStarted);
//	ClearBit(vbHomeStarted);
#endif

	if (!ReadBit(vbInitialized))	// Run only on first powerup
	{

		SPI_Init();
	
		ClearBit(pLED1);
		ClearBit(pLED2);
		
		ClearBit(vbMachineHomed);
		ClearBit(vbSoftlimitEn);
		ClearBit(vbHomeStarted);
		ClearBit(vbAbortHome);
		ClearBit(vbToolChangeStarted);

		//------------------------
		if (UserCallBack != NULL)		
		{
			printf("KillCallback\n");
			ClearBit(vbInitialized);
			Delay_sec(0.2);			// Give some time for callback to finish
			UserCallBack = NULL;	// Kill Callback if it's running	
			Delay_sec(0.3);			// Give some time for callback to finish
		}
		//------------------------
		
		if (persist.UserData[pdBoardDefault] != DEFAULT_KEY)
			DefaultPersist();

		ReadPersist();
		
		switch (persist.UserData[pdControlType])
		{
		case TYPE_DC_SERVO:
			InitServo();
			break;
		case TYPE_DC_SERVO_REV4:
			InitServo();
			break;
		case TYPE_DC_STEP_DIR:
			InitStepDir();
			break;
		case TYPE_AC_SERVO_ANALOG:
			InitACAnalog();
			break;
		case TYPE_AC_SERVO_STEP_DIR:
			InitACStepDir();
			break;
		}


		FlashLEDS();			
		SetBit(vbInitialized);	

		DisableAxis(0);
		DisableAxis(1);
		DisableAxis(2);
		DisableAxis(3);
		DisableAxis(4);
		
		UserCallBack = CallBack;	// Initiate Callback

		PrintFirmwareVersion();
		//printf("Ready\n");

	}	

	StartThread(JOG_LIMIT_THREAD);
	
	ClearBit(vbThread6Started);

}

